--TrasitionTime
_TT={
	S_IN=0.4,
	S_OUT=0.4;
};
--HeaderSize
_HS=50;
_HS2=_HS/2

local d3=tobool(GetUserPref_Theme("D3MIXMode")) or false;
setenv("D3MIXMode",d3);

function _GAME()
	return string.lower(GAMESTATE:GetCurrentGame():GetName());
end

function D3OptionsLine()
	if GetSMVersion()>=50 then
		return "gAuto,gComboUnderField,FlashyCombo,BGAtoLua,CustomScore,HoldJudg,HoldCheck,NGCombo,MineHitMiss,MinCombo,Haishin,BGScale,DifficultyName,DifficultyColor,JudgementLabel,WheelMode,ResultBGM";
	else
		return "gAuto,gComboUnderField,FlashyCombo,BGAtoLua,CustomScore,HoldJudg,HoldCheck,MineHitMiss,MinCombo,Haishin,BGScale,DifficultyName,DifficultyColor,JudgementLabel,WheelMode,ResultBGM";
	end;
end;

function DrillCode()
	if _GAME()~="pump" then
		return "Start,BackD,BackU,Select,Left,Left2,Right,Right2";
	else
		return "Start,BackD,BackU,Select,Left,Left3,Left4,Right,Right3,Right4,Center";
	end;
end;

function DrillEvaluationCode()
	if _GAME()~="pump" then
		return "Start,Back,Select,Left,Left2,Right,Right2";
	else
		return "Start,Back,Select,Left,Left3,Left4,Right,Right3,Right4,Center";
	end;
end;

function SelectMusicCloseFolder()
	if _GAME()~="pump" then
		return "UP-DOWN";
	else
		return "MenuUp-MenuDown";
	end;
end;

function SelectMusicCode()
	if _GAME()~="pump" then
		return "ViewScore,ExFolder,ViewScore2=ViewScore,ExFolder2=ExFolder,Start,MiniOption";
	else
		return "ViewScore2=ViewScore,ExFolder2=ExFolder,ViewScore3=ViewScore,ExFolder3=ExFolder,Start,MiniOption";
	end;
end;

function EXFolderIntroCode()
	if _GAME()~="pump" then
		return "Start,Back,Back,Left,Left2=Left,Right,Right2=Right,Up,Up2=Up,Down,Down2=Down,EffectUp,EffectDown";
	else
		return "Start,Back,Back,Center=Start,Left,Left3=Left,Right,Right3=Right,Up,Up3=Up,Down,Down3=Down,EffectUp,EffectDown";
	end;
end;

function SelectExMusicCode()
	if _GAME()~="pump" then
		return "Start,BackD,BackU,Left,Left2,Right,Right2,Up,Up2,Down,Down2";
	else
		return "Start,BackD,BackU,Center,Left,Left3,Right,Right3,Up,Up3,Down,Down3";
	end;
end;

function OpeningCode()
	if _GAME()~="pump" then
		return "Start,Back,Left1,Left2,Right1,Right2";
	else
		return "Start,Back,Left1,Left3,Left4,Right1,Right3,Right4,Center";
	end;
end;

function D3LogoCode()
	if _GAME()~="pump" then
		return "Start,Back,Left1,Left2,Right1,Right2,Seclet1";
	else
		return "Start,Back,Left1,Left3,Left4,Right1,Right3,Right4,Seclet2,Center";
	end;
end;

function CautionCode()
	if _GAME()~="pump" then
		return "Start,Back";
	else
		return "Start,Back,Center";
	end;
end;

function DialogCode()
	if _GAME()~="pump" then
		return "Start,Back,Left,Left2=Left,Right,Right2=Right";
	else
		return "Start,Back,Left,Left3=Left,Left4=Left,Right,Right3=Right,Right4=Right,Center";
	end;
end;

function GameplayCode()
	if _GAME()~="pump" then
		return "ScrollNomal,ScrollNomal2=ScrollNomal,ScrollReverse,ScrollReverse2=ScrollReverse,ScrollPIUNomal,ScrollPIUReverse,HiSpeedUp,HiSpeedUp2=HiSpeedUp,HiSpeedDown,HiSpeedDown2=HiSpeedDown";
	else
		return "ScrollNomal,ScrollNomal3=ScrollNomal,ScrollReverse,ScrollReverse3=ScrollReverse,ScrollPIUNomal,ScrollPIUReverse,HiSpeedUp,HiSpeedUp3=HiSpeedUp,HiSpeedDown,HiSpeedDown3=HiSpeedDown";
	end;
end;

function EvaluationNormalCode()
	if _GAME()~="pump" then
		return "SwitchSongTitle,SwitchSongTitle2=SwitchSongTitle,SwitchSongTitle3=SwitchSongTitle,SwitchSongTitle4=SwitchSongTitle,ShowPopup,ShowPopup2=ShowPopup";
	else
		return "SwitchSongTitle3=SwitchSongTitle,SwitchSongTitle4=SwitchSongTitle,SwitchSongTitle5=SwitchSongTitle,SwitchSongTitle6=SwitchSongTitle,ShowPopup,ShowPopup3=ShowPopup";
	end;
end;

function EvaluationSummaryCode()
	if _GAME()~="pump" then
		return "PrevSong,PrevSong2=PrevSong,NextSong,NextSong2=NextSong";
	else
		return "PrevSong,PrevSong3=PrevSong,PrevSong4=PrevSong,NextSong,NextSong3=NextSong,NextSong4=NextSong";
	end;
end;

function GetBannerStat(song,wheelmode)
	local tmp={};
	local fall_bg=THEME:GetPathG("Common fallback","jacket");
	local fall_bn=THEME:GetPathG("Common fallback","banner");
	local g=fall_bg;
	tmp[2]=-1;
	local cdtitle=song:GetCDTitlePath();
	if wheelmode=="JBN" then
		if song:HasJacket() and song:GetJacketPath()~=cdtitle then
			g=song:GetJacketPath();
			tmp[2]=3;
		elseif song:HasCDImage() and song:GetCDImagePath()~=cdtitle then
			g=song:GetCDImagePath();
			tmp[2]=3;
		elseif song:HasBanner() then
			g=song:GetBannerPath();
			tmp[2]=1;
		elseif song:HasBackground() then
			g=song:GetBackgroundPath();
			tmp[2]=2;
		else
			g=fall_bg;
			tmp[2]=-1;
		end;
	elseif wheelmode=="JBG" then
		if song:HasJacket() and song:GetJacketPath()~=cdtitle then
			g=song:GetJacketPath();
			tmp[2]=3;
		elseif song:HasCDImage() and song:GetCDImagePath()~=cdtitle then
			g=song:GetCDImagePath();
			tmp[2]=3;
		elseif song:HasBackground() and song:GetBackgroundPath()~=cdtitle then
			g=song:GetBackgroundPath();
			tmp[2]=2;
		elseif song:HasBanner() then
			g=song:GetBannerPath();
			tmp[2]=1;
		else
			g=fall_bg;
			tmp[2]=-1;
		end;
	elseif wheelmode=="BNJ" then
		if song:HasBanner() then
			g=song:GetBannerPath();
			tmp[2]=1;
		elseif song:HasJacket() and song:GetJacketPath()~=cdtitle then
			g=song:GetJacketPath();
			tmp[2]=3;
		elseif song:HasCDImage() and song:GetCDImagePath()~=cdtitle then
			g=song:GetCDImagePath();
			tmp[2]=3;
		elseif song:HasBackground() then
			g=song:GetBackgroundPath();
			tmp[2]=2;
		else
			g=fall_bn;
			tmp[2]=-1;
		end;
	elseif wheelmode=="BGJ" then
		if song:HasBackground() and song:GetBackgroundPath()~=cdtitle then
			g=song:GetBackgroundPath();
			tmp[2]=2;
		elseif song:HasJacket() and song:GetJacketPath()~=cdtitle then
			g=song:GetJacketPath();
			tmp[2]=3;
		elseif song:HasCDImage() and song:GetCDImagePath()~=cdtitle then
			g=song:GetCDImagePath();
			tmp[2]=3;
		elseif song:HasBanner() then
			g=song:GetBannerPath();
			tmp[2]=1;
		else
			g=fall_bg;
			tmp[2]=-1;
		end;
	end;
	tmp[1]=g;
	return tmp;
end;

function GameStyleDefaultChoice()
	if GAMESTATE:GetCurrentGame():GetName()=="dance" and GAMESTATE:GetNumPlayersEnabled()>=2 then
		return "Versus";
	else
		return "Single";
	end;
end;

function HeaderColor()
	local name = Var "LoadingScreen";
	if name=="ScreenSelectStyle" then
		return color("0.3,0.6,1.0,1.0");
	elseif name=="ScreenSelectPlayMode" then
		return color("0.3,0.8,0.2,1.0");
	elseif name=="ScreenSelectMusic"
		or name=="ScreenNetSelectMusic"
		or name=="ScreenSelectDrillCategory" then
		return color("1.0,0.6,0.2,1.0");
	elseif name=="ScreenSelectExMusic"
		or name=="ScreenSelectDrillDifficulty" then
		return color("1.0,0.1,0.2,1.0");
	elseif name=="GLAY" then
		return color("0.6,0.6,0.6,1.0");
	end;
	if getenv("D3MIXMode") then
		return color("0.3,0.6,1.0,1.0");
	else
		return color("1.0,0.3,0.6,1.0");
	end;
end;

function IsAutoSetStyle()
	return THEME:GetMetric("Common","AutoSetStyle") and (GAMESTATE:GetCurrentGame():GetName()=="dance");
end;

function GameCompatibleModes_Theme()
	local Modes = {};
	if IsAutoSetStyle() then
		if GAMESTATE:GetNumPlayersEnabled()>=2 then
			Modes = {
				dance = "Versus",
				pump = "Single,Double,HalfDouble,Versus,Couple,Routine",
				beat = "5Keys,7Keys,10Keys,14Keys,Versus5,Versus7",
				kb7 = "KB7",
				para = "Single",
				maniax = "Single,Double,Versus",
				-- todo: add versus modes for technomotion
				techno = "Single4,Single5,Single8,Double4,Double5,Double8",
				lights = "Single" -- lights shouldn't be playable
			}
		else
			Modes = {
				dance = "Single,Double",
				pump = "Single,Double,HalfDouble,Versus,Couple,Routine",
				beat = "5Keys,7Keys,10Keys,14Keys,Versus5,Versus7",
				kb7 = "KB7",
				para = "Single",
				maniax = "Single,Double,Versus",
				-- todo: add versus modes for technomotion
				techno = "Single4,Single5,Single8,Double4,Double5,Double8",
				lights = "Single" -- lights shouldn't be playable
			}
		end;
	else
		Modes = {
			dance = "Single,Double,Versus",
			pump = "Single,Double,HalfDouble,Versus,Couple,Routine",
			beat = "5Keys,7Keys,10Keys,14Keys,Versus5,Versus7",
			kb7 = "KB7",
			para = "Single",
			maniax = "Single,Double,Versus",
			-- todo: add versus modes for technomotion
			techno = "Single4,Single5,Single8,Double4,Double5,Double8",
			lights = "Single" -- lights shouldn't be playable
		}
	end;
	return Modes[GAMESTATE:GetCurrentGame():GetName()];
end